<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LineUp extends Model 
{

    protected $table = 'lineup';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'year');
    protected $visible = array('name', 'year');

    public function peliculas()
    {
        return $this->hasManyThrough('Pelicula', 'lineup_peliculas', 'lineup_id', 'pelicula_id');
    }

    public function peliculas_lineup()
    {
        return $this->hasMany('LineUpPelicula', 'lineup_id');
    }

}